/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.dictionaries.furniture;

import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureCategoryDictionary;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureLayoutDictionary;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.item.QuantifiedItemType;
import technology.rocketjump.undermount.jobs.CraftingTypeDictionary;
import technology.rocketjump.undermount.jobs.model.CraftingType;

@Singleton
public class FurnitureTypeDictionary {
    private final Map<String, FurnitureType> byName = new HashMap<String, FurnitureType>();
    private final List<FurnitureType> placeAnywhereFurniture = new LinkedList<FurnitureType>();
    public static FurnitureType NULL_TYPE = new FurnitureType();

    @Inject
    public FurnitureTypeDictionary(FurnitureCategoryDictionary categoryDictionary, FurnitureLayoutDictionary layoutDictionary, CraftingTypeDictionary craftingTypeDictionary, ItemTypeDictionary itemTypeDictionary) throws IOException {
        this(new FileHandle("assets/definitions/furnitureTypes.json"), categoryDictionary, layoutDictionary, craftingTypeDictionary, itemTypeDictionary);
    }

    public FurnitureTypeDictionary(FileHandle jsonFile, FurnitureCategoryDictionary categoryDictionary, FurnitureLayoutDictionary layoutDictionary, CraftingTypeDictionary craftingTypeDictionary, ItemTypeDictionary itemTypeDictionary) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        List furnitureTypes = (List)objectMapper.readValue(jsonFile.readString(), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, FurnitureType.class));
        for (FurnitureType furnitureType : furnitureTypes) {
            this.initialiseFurnitureType(furnitureType, categoryDictionary, layoutDictionary, craftingTypeDictionary, itemTypeDictionary);
            this.byName.put(furnitureType.getName(), furnitureType);
            if (!furnitureType.isPlaceAnywhere()) continue;
            this.placeAnywhereFurniture.add(furnitureType);
        }
        this.byName.put(NULL_TYPE.getName(), NULL_TYPE);
    }

    public List<FurnitureType> getPlaceAnywhereFurniture() {
        return this.placeAnywhereFurniture;
    }

    private void initialiseFurnitureType(FurnitureType furnitureType, FurnitureCategoryDictionary categoryDictionary, FurnitureLayoutDictionary layoutDictionary, CraftingTypeDictionary craftingTypeDictionary, ItemTypeDictionary itemTypeDictionary) {
        furnitureType.setFurnitureCategory(categoryDictionary.getByName(furnitureType.getCategoryName()));
        if (furnitureType.getFurnitureCategory() == null) {
            throw new RuntimeException("Could not find furniture category: " + furnitureType.getCategoryName() + " for " + furnitureType.getName());
        }
        furnitureType.setDefaultLayout(layoutDictionary.getByName(furnitureType.getDefaultLayoutName()));
        if (furnitureType.getDefaultLayout() == null) {
            throw new RuntimeException("Could not find furniture layout: " + furnitureType.getDefaultLayoutName() + " for " + furnitureType.getName());
        }
        if (furnitureType.getCraftingTypeName() != null) {
            CraftingType craftingType = craftingTypeDictionary.getByName(furnitureType.getCraftingTypeName());
            if (craftingType == null) {
                throw new RuntimeException("Could not find crafting type: " + furnitureType.getCraftingTypeName() + " for " + furnitureType.getName());
            }
            furnitureType.setCraftingType(craftingType);
        }
        if (furnitureType.getRequirements() != null) {
            for (List<QuantifiedItemType> quantifiedItemTypes : furnitureType.getRequirements().values()) {
                for (QuantifiedItemType quantifiedItemType : quantifiedItemTypes) {
                    ItemType itemType = itemTypeDictionary.getByName(quantifiedItemType.getItemTypeName());
                    if (itemType == null) {
                        throw new RuntimeException("Could not find item type: " + quantifiedItemType.getItemTypeName() + " for " + quantifiedItemType + " in " + furnitureType.getName());
                    }
                    quantifiedItemType.setItemType(itemType);
                }
            }
        }
    }

    public FurnitureType getByName(String name) {
        return this.byName.get(name);
    }

    public Collection<FurnitureType> getAll() {
        return this.byName.values();
    }

    static {
        NULL_TYPE.setName("Null furniture type");
    }
}

